/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.SuggestionContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class CommandSuggestionHelper {
    private static final Pattern field_228092_a_ = Pattern.compile("(\\s+)");
    private static final Style field_243252_b = Style.field_240709_b_.func_240712_a_(TextFormatting.RED);
    private static final Style field_243253_c = Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY);
    private static final List<Style> field_243254_d = (List)Stream.of(TextFormatting.AQUA, TextFormatting.YELLOW, TextFormatting.GREEN, TextFormatting.LIGHT_PURPLE, TextFormatting.GOLD).map(Style.field_240709_b_::func_240712_a_).collect(ImmutableList.toImmutableList());
    private final Minecraft field_228093_b_;
    private final Screen field_228094_c_;
    private final TextFieldWidget field_228095_d_;
    private final FontRenderer field_228096_e_;
    private final boolean field_228097_f_;
    private final boolean field_228098_g_;
    private final int field_228099_h_;
    private final int field_228100_i_;
    private final boolean field_228101_j_;
    private final int field_228102_k_;
    private final List<IReorderingProcessor> field_228103_l_ = Lists.newArrayList();
    private int field_228104_m_;
    private int field_228105_n_;
    private ParseResults<ISuggestionProvider> field_228106_o_;
    private CompletableFuture<com.mojang.brigadier.suggestion.Suggestions> field_228107_p_;
    private Suggestions field_228108_q_;
    private boolean field_228109_r_;
    private boolean field_228110_s_;

    public CommandSuggestionHelper(Minecraft minecraft, Screen screen, TextFieldWidget textFieldWidget, FontRenderer fontRenderer, boolean bl, boolean bl2, int n, int n2, boolean bl3, int n3) {
        this.field_228093_b_ = minecraft;
        this.field_228094_c_ = screen;
        this.field_228095_d_ = textFieldWidget;
        this.field_228096_e_ = fontRenderer;
        this.field_228097_f_ = bl;
        this.field_228098_g_ = bl2;
        this.field_228099_h_ = n;
        this.field_228100_i_ = n2;
        this.field_228101_j_ = bl3;
        this.field_228102_k_ = n3;
        textFieldWidget.func_195607_a(this::func_228122_a_);
    }

    public void func_228124_a_(boolean bl) {
        this.field_228109_r_ = bl;
        if (!bl) {
            this.field_228108_q_ = null;
        }
    }

    public boolean func_228115_a_(int n, int n2, int n3) {
        if (this.field_228108_q_ != null && this.field_228108_q_.func_228154_b_(n, n2, n3)) {
            return true;
        }
        if (this.field_228094_c_.func_241217_q_() == this.field_228095_d_ && n == 258) {
            this.func_228128_b_(true);
            return true;
        }
        return false;
    }

    public boolean func_228112_a_(double d) {
        return this.field_228108_q_ != null && this.field_228108_q_.func_228147_a_(MathHelper.func_151237_a(d, -1.0, 1.0));
    }

    public boolean func_228113_a_(double d, double d2, int n) {
        return this.field_228108_q_ != null && this.field_228108_q_.func_228150_a_((int)d, (int)d2, n);
    }

    public void func_228128_b_(boolean bl) {
        if (this.field_228107_p_ != null && this.field_228107_p_.isDone() && !(suggestions = this.field_228107_p_.join()).isEmpty()) {
            com.mojang.brigadier.suggestion.Suggestions suggestions;
            int n = 0;
            for (Suggestion suggestion : suggestions.getList()) {
                n = Math.max(n, this.field_228096_e_.func_78256_a(suggestion.getText()));
            }
            int \u26032 = MathHelper.func_76125_a(this.field_228095_d_.func_195611_j(suggestions.getRange().getStart()), 0, this.field_228095_d_.func_195611_j(0) + this.field_228095_d_.func_146200_o() - n);
            int \u26033 = this.field_228101_j_ ? this.field_228094_c_.field_230709_l_ - 12 : 72;
            this.field_228108_q_ = new Suggestions(\u26032, \u26033, n, this.func_241575_a_(suggestions), bl);
        }
    }

    private List<Suggestion> func_241575_a_(com.mojang.brigadier.suggestion.Suggestions suggestions) {
        String string = this.field_228095_d_.func_146179_b().substring(0, this.field_228095_d_.func_146198_h());
        int \u26032 = CommandSuggestionHelper.func_228121_a_(string);
        \u2603 = string.substring(\u26032).toLowerCase(Locale.ROOT);
        ArrayList \u26033 = Lists.newArrayList();
        ArrayList \u26034 = Lists.newArrayList();
        for (Suggestion suggestion : suggestions.getList()) {
            if (suggestion.getText().startsWith(\u2603) || suggestion.getText().startsWith("minecraft:" + \u2603)) {
                \u26033.add(suggestion);
                continue;
            }
            \u26034.add(suggestion);
        }
        \u26033.addAll(\u26034);
        return \u26033;
    }

    public void func_228111_a_() {
        String string = this.field_228095_d_.func_146179_b();
        if (this.field_228106_o_ != null && !this.field_228106_o_.getReader().getString().equals(string)) {
            this.field_228106_o_ = null;
        }
        if (!this.field_228110_s_) {
            this.field_228095_d_.func_195612_c(null);
            this.field_228108_q_ = null;
        }
        this.field_228103_l_.clear();
        StringReader \u26032 = new StringReader(string);
        boolean bl = \u2603 = \u26032.canRead() && \u26032.peek() == '/';
        if (\u2603) {
            \u26032.skip();
        }
        boolean \u26033 = this.field_228097_f_ || \u2603;
        int \u26034 = this.field_228095_d_.func_146198_h();
        if (\u26033) {
            CommandDispatcher<ISuggestionProvider> commandDispatcher = this.field_228093_b_.field_71439_g.field_71174_a.func_195515_i();
            if (this.field_228106_o_ == null) {
                this.field_228106_o_ = commandDispatcher.parse(\u26032, (Object)this.field_228093_b_.field_71439_g.field_71174_a.func_195513_b());
            }
            int n = \u2603 = this.field_228098_g_ ? \u26032.getCursor() : 1;
            if (!(\u26034 < \u2603 || this.field_228108_q_ != null && this.field_228110_s_)) {
                this.field_228107_p_ = commandDispatcher.getCompletionSuggestions(this.field_228106_o_, \u26034);
                this.field_228107_p_.thenRun(() -> {
                    if (!this.field_228107_p_.isDone()) {
                        return;
                    }
                    this.func_228125_b_();
                });
            }
        } else {
            \u2603 = string.substring(0, \u26034);
            int \u26035 = CommandSuggestionHelper.func_228121_a_(\u2603);
            Collection<String> \u26036 = this.field_228093_b_.field_71439_g.field_71174_a.func_195513_b().func_197011_j();
            this.field_228107_p_ = ISuggestionProvider.func_197005_b(\u26036, new SuggestionsBuilder(\u2603, \u26035));
        }
    }

    private static int func_228121_a_(String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return 0;
        }
        int n = 0;
        Matcher \u26032 = field_228092_a_.matcher(string);
        while (\u26032.find()) {
            n = \u26032.end();
        }
        return n;
    }

    private static IReorderingProcessor func_243255_a(CommandSyntaxException commandSyntaxException) {
        ITextComponent iTextComponent = TextComponentUtils.func_202465_a(commandSyntaxException.getRawMessage());
        String \u26032 = commandSyntaxException.getContext();
        if (\u26032 == null) {
            return iTextComponent.func_241878_f();
        }
        return new TranslationTextComponent("command.context.parse_error", iTextComponent, commandSyntaxException.getCursor(), \u26032).func_241878_f();
    }

    private void func_228125_b_() {
        if (this.field_228095_d_.func_146198_h() == this.field_228095_d_.func_146179_b().length()) {
            if (this.field_228107_p_.join().isEmpty() && !this.field_228106_o_.getExceptions().isEmpty()) {
                int n = 0;
                for (Map.Entry entry : this.field_228106_o_.getExceptions().entrySet()) {
                    CommandSyntaxException commandSyntaxException = (CommandSyntaxException)entry.getValue();
                    if (commandSyntaxException.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.literalIncorrect()) {
                        ++n;
                        continue;
                    }
                    this.field_228103_l_.add(CommandSuggestionHelper.func_243255_a(commandSyntaxException));
                }
                if (n > 0) {
                    this.field_228103_l_.add(CommandSuggestionHelper.func_243255_a(CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().create()));
                }
            } else if (this.field_228106_o_.getReader().canRead()) {
                this.field_228103_l_.add(CommandSuggestionHelper.func_243255_a(Commands.func_227481_a_(this.field_228106_o_)));
            }
        }
        this.field_228104_m_ = 0;
        this.field_228105_n_ = this.field_228094_c_.field_230708_k_;
        if (this.field_228103_l_.isEmpty()) {
            this.func_228120_a_(TextFormatting.GRAY);
        }
        this.field_228108_q_ = null;
        if (this.field_228109_r_ && this.field_228093_b_.field_71474_y.field_198018_T) {
            this.func_228128_b_(false);
        }
    }

    private void func_228120_a_(TextFormatting textFormatting) {
        CommandContextBuilder commandContextBuilder = this.field_228106_o_.getContext();
        SuggestionContext \u26032 = commandContextBuilder.findSuggestionContext(this.field_228095_d_.func_146198_h());
        Map \u26033 = this.field_228093_b_.field_71439_g.field_71174_a.func_195515_i().getSmartUsage(\u26032.parent, (Object)this.field_228093_b_.field_71439_g.field_71174_a.func_195513_b());
        ArrayList \u26034 = Lists.newArrayList();
        int \u26035 = 0;
        Style \u26036 = Style.field_240709_b_.func_240712_a_(textFormatting);
        for (Map.Entry entry : \u26033.entrySet()) {
            if (entry.getKey() instanceof LiteralCommandNode) continue;
            \u26034.add(IReorderingProcessor.func_242239_a((String)entry.getValue(), \u26036));
            \u26035 = Math.max(\u26035, this.field_228096_e_.func_78256_a((String)entry.getValue()));
        }
        if (!\u26034.isEmpty()) {
            this.field_228103_l_.addAll(\u26034);
            this.field_228104_m_ = MathHelper.func_76125_a(this.field_228095_d_.func_195611_j(\u26032.startPos), 0, this.field_228095_d_.func_195611_j(0) + this.field_228095_d_.func_146200_o() - \u26035);
            this.field_228105_n_ = \u26035;
        }
    }

    private IReorderingProcessor func_228122_a_(String string, int n) {
        if (this.field_228106_o_ != null) {
            return CommandSuggestionHelper.func_228116_a_(this.field_228106_o_, string, n);
        }
        return IReorderingProcessor.func_242239_a(string, Style.field_240709_b_);
    }

    @Nullable
    private static String func_228127_b_(String string, String string2) {
        if (string2.startsWith(string)) {
            return string2.substring(string.length());
        }
        return null;
    }

    private static IReorderingProcessor func_228116_a_(ParseResults<ISuggestionProvider> parseResults2, String string, int n) {
        ParseResults<ISuggestionProvider> parseResults2;
        ArrayList arrayList = Lists.newArrayList();
        int \u26032 = 0;
        int \u26033 = -1;
        CommandContextBuilder \u26034 = parseResults2.getContext().getLastChild();
        for (ParsedArgument parsedArgument : \u26034.getArguments().values()) {
            if (++\u26033 >= field_243254_d.size()) {
                \u26033 = 0;
            }
            if ((\u2603 = Math.max(parsedArgument.getRange().getStart() - n, 0)) >= string.length()) break;
            int n2 = Math.min(parsedArgument.getRange().getEnd() - n, string.length());
            if (n2 <= 0) continue;
            arrayList.add(IReorderingProcessor.func_242239_a(string.substring(\u26032, \u2603), field_243253_c));
            arrayList.add(IReorderingProcessor.func_242239_a(string.substring(\u2603, n2), field_243254_d.get(\u26033)));
            \u26032 = n2;
        }
        if (parseResults2.getReader().canRead() && (\u2603 = Math.max(parseResults2.getReader().getCursor() - n, 0)) < string.length()) {
            int n3 = Math.min(\u2603 + parseResults2.getReader().getRemainingLength(), string.length());
            arrayList.add(IReorderingProcessor.func_242239_a(string.substring(\u26032, \u2603), field_243253_c));
            arrayList.add(IReorderingProcessor.func_242239_a(string.substring(\u2603, n3), field_243252_b));
            \u26032 = n3;
        }
        arrayList.add(IReorderingProcessor.func_242239_a(string.substring(\u26032), field_243253_c));
        return IReorderingProcessor.func_242241_a(arrayList);
    }

    public void func_238500_a_(MatrixStack matrixStack, int n, int n2) {
        if (this.field_228108_q_ != null) {
            this.field_228108_q_.func_238501_a_(matrixStack, n, n2);
        } else {
            \u2603 = 0;
            for (IReorderingProcessor iReorderingProcessor : this.field_228103_l_) {
                int n3 = this.field_228101_j_ ? this.field_228094_c_.field_230709_l_ - 14 - 13 - 12 * \u2603 : 72 + 12 * \u2603;
                AbstractGui.func_238467_a_(matrixStack, this.field_228104_m_ - 1, n3, this.field_228104_m_ + this.field_228105_n_ + 1, n3 + 12, this.field_228102_k_);
                this.field_228096_e_.func_238407_a_(matrixStack, iReorderingProcessor, this.field_228104_m_, n3 + 2, -1);
                ++\u2603;
            }
        }
    }

    public String func_228129_c_() {
        if (this.field_228108_q_ != null) {
            return "\n" + this.field_228108_q_.func_228155_c_();
        }
        return "";
    }

    public class Suggestions {
        private final Rectangle2d field_228138_b_;
        private final String field_228140_d_;
        private final List<Suggestion> field_241576_d_;
        private int field_228141_e_;
        private int field_228142_f_;
        private Vector2f field_228143_g_ = Vector2f.field_189974_a;
        private boolean field_228144_h_;
        private int field_228145_i_;

        private Suggestions(int n, int n2, int n3, List<Suggestion> list, boolean bl) {
            int n4 = n - 1;
            \u2603 = CommandSuggestionHelper.this.field_228101_j_ ? n2 - 3 - Math.min(list.size(), CommandSuggestionHelper.this.field_228100_i_) * 12 : n2;
            this.field_228138_b_ = new Rectangle2d(n4, \u2603, n3 + 1, Math.min(list.size(), CommandSuggestionHelper.this.field_228100_i_) * 12);
            this.field_228140_d_ = CommandSuggestionHelper.this.field_228095_d_.func_146179_b();
            this.field_228145_i_ = bl ? -1 : 0;
            this.field_241576_d_ = list;
            this.func_228153_b_(0);
        }

        public void func_238501_a_(MatrixStack matrixStack2, int n, int n2) {
            int n3;
            \u2603 = Math.min(this.field_241576_d_.size(), CommandSuggestionHelper.this.field_228100_i_);
            \u2603 = -5592406;
            boolean bl = this.field_228141_e_ > 0;
            bl3 = this.field_241576_d_.size() > this.field_228141_e_ + \u2603;
            \u2603 = bl || bl3;
            boolean bl2 = \u2603 = this.field_228143_g_.field_189982_i != (float)n || this.field_228143_g_.field_189983_j != (float)n2;
            if (\u2603) {
                this.field_228143_g_ = new Vector2f(n, n2);
            }
            if (\u2603) {
                boolean bl3;
                AbstractGui.func_238467_a_(matrixStack2, this.field_228138_b_.func_199318_a(), this.field_228138_b_.func_199319_b() - 1, this.field_228138_b_.func_199318_a() + this.field_228138_b_.func_199316_c(), this.field_228138_b_.func_199319_b(), CommandSuggestionHelper.this.field_228102_k_);
                AbstractGui.func_238467_a_(matrixStack2, this.field_228138_b_.func_199318_a(), this.field_228138_b_.func_199319_b() + this.field_228138_b_.func_199317_d(), this.field_228138_b_.func_199318_a() + this.field_228138_b_.func_199316_c(), this.field_228138_b_.func_199319_b() + this.field_228138_b_.func_199317_d() + 1, CommandSuggestionHelper.this.field_228102_k_);
                if (bl) {
                    for (n3 = 0; n3 < this.field_228138_b_.func_199316_c(); ++n3) {
                        if (n3 % 2 != 0) continue;
                        AbstractGui.func_238467_a_(matrixStack2, this.field_228138_b_.func_199318_a() + n3, this.field_228138_b_.func_199319_b() - 1, this.field_228138_b_.func_199318_a() + n3 + 1, this.field_228138_b_.func_199319_b(), -1);
                    }
                }
                if (bl3) {
                    for (n3 = 0; n3 < this.field_228138_b_.func_199316_c(); ++n3) {
                        if (n3 % 2 != 0) continue;
                        AbstractGui.func_238467_a_(matrixStack2, this.field_228138_b_.func_199318_a() + n3, this.field_228138_b_.func_199319_b() + this.field_228138_b_.func_199317_d(), this.field_228138_b_.func_199318_a() + n3 + 1, this.field_228138_b_.func_199319_b() + this.field_228138_b_.func_199317_d() + 1, -1);
                    }
                }
            }
            n3 = 0;
            for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                MatrixStack matrixStack2;
                Suggestion suggestion = this.field_241576_d_.get(\u2603 + this.field_228141_e_);
                AbstractGui.func_238467_a_(matrixStack2, this.field_228138_b_.func_199318_a(), this.field_228138_b_.func_199319_b() + 12 * \u2603, this.field_228138_b_.func_199318_a() + this.field_228138_b_.func_199316_c(), this.field_228138_b_.func_199319_b() + 12 * \u2603 + 12, CommandSuggestionHelper.this.field_228102_k_);
                if (n > this.field_228138_b_.func_199318_a() && n < this.field_228138_b_.func_199318_a() + this.field_228138_b_.func_199316_c() && n2 > this.field_228138_b_.func_199319_b() + 12 * \u2603 && n2 < this.field_228138_b_.func_199319_b() + 12 * \u2603 + 12) {
                    if (\u2603) {
                        this.func_228153_b_(\u2603 + this.field_228141_e_);
                    }
                    n3 = 1;
                }
                CommandSuggestionHelper.this.field_228096_e_.func_238405_a_(matrixStack2, suggestion.getText(), this.field_228138_b_.func_199318_a() + 1, this.field_228138_b_.func_199319_b() + 2 + 12 * \u2603, \u2603 + this.field_228141_e_ == this.field_228142_f_ ? -256 : -5592406);
            }
            if (n3 != 0 && (\u2603 = this.field_241576_d_.get(this.field_228142_f_).getTooltip()) != null) {
                CommandSuggestionHelper.this.field_228094_c_.func_238652_a_(matrixStack2, TextComponentUtils.func_202465_a(\u2603), n, n2);
            }
        }

        public boolean func_228150_a_(int n, int n2, int n3) {
            if (!this.field_228138_b_.func_199315_b(n, n2)) {
                return false;
            }
            \u2603 = (n2 - this.field_228138_b_.func_199319_b()) / 12 + this.field_228141_e_;
            if (\u2603 >= 0 && \u2603 < this.field_241576_d_.size()) {
                this.func_228153_b_(\u2603);
                this.func_228146_a_();
            }
            return true;
        }

        public boolean func_228147_a_(double d) {
            int n = (int)(((CommandSuggestionHelper)CommandSuggestionHelper.this).field_228093_b_.field_71417_B.func_198024_e() * (double)CommandSuggestionHelper.this.field_228093_b_.func_228018_at_().func_198107_o() / (double)CommandSuggestionHelper.this.field_228093_b_.func_228018_at_().func_198105_m());
            if (this.field_228138_b_.func_199315_b(n, \u2603 = (int)(((CommandSuggestionHelper)CommandSuggestionHelper.this).field_228093_b_.field_71417_B.func_198026_f() * (double)CommandSuggestionHelper.this.field_228093_b_.func_228018_at_().func_198087_p() / (double)CommandSuggestionHelper.this.field_228093_b_.func_228018_at_().func_198083_n()))) {
                this.field_228141_e_ = MathHelper.func_76125_a((int)((double)this.field_228141_e_ - d), 0, Math.max(this.field_241576_d_.size() - CommandSuggestionHelper.this.field_228100_i_, 0));
                return true;
            }
            return false;
        }

        public boolean func_228154_b_(int n, int n2, int n3) {
            if (n == 265) {
                this.func_228148_a_(-1);
                this.field_228144_h_ = false;
                return true;
            }
            if (n == 264) {
                this.func_228148_a_(1);
                this.field_228144_h_ = false;
                return true;
            }
            if (n == 258) {
                if (this.field_228144_h_) {
                    this.func_228148_a_(Screen.func_231173_s_() ? -1 : 1);
                }
                this.func_228146_a_();
                return true;
            }
            if (n == 256) {
                this.func_228152_b_();
                return true;
            }
            return false;
        }

        public void func_228148_a_(int n) {
            this.func_228153_b_(this.field_228142_f_ + n);
            \u2603 = this.field_228141_e_;
            \u2603 = this.field_228141_e_ + CommandSuggestionHelper.this.field_228100_i_ - 1;
            if (this.field_228142_f_ < \u2603) {
                this.field_228141_e_ = MathHelper.func_76125_a(this.field_228142_f_, 0, Math.max(this.field_241576_d_.size() - CommandSuggestionHelper.this.field_228100_i_, 0));
            } else if (this.field_228142_f_ > \u2603) {
                this.field_228141_e_ = MathHelper.func_76125_a(this.field_228142_f_ + CommandSuggestionHelper.this.field_228099_h_ - CommandSuggestionHelper.this.field_228100_i_, 0, Math.max(this.field_241576_d_.size() - CommandSuggestionHelper.this.field_228100_i_, 0));
            }
        }

        public void func_228153_b_(int n) {
            this.field_228142_f_ = n;
            if (this.field_228142_f_ < 0) {
                this.field_228142_f_ += this.field_241576_d_.size();
            }
            if (this.field_228142_f_ >= this.field_241576_d_.size()) {
                this.field_228142_f_ -= this.field_241576_d_.size();
            }
            Suggestion suggestion = this.field_241576_d_.get(this.field_228142_f_);
            CommandSuggestionHelper.this.field_228095_d_.func_195612_c(CommandSuggestionHelper.func_228127_b_(CommandSuggestionHelper.this.field_228095_d_.func_146179_b(), suggestion.apply(this.field_228140_d_)));
            if (NarratorChatListener.field_193643_a.func_193640_a() && this.field_228145_i_ != this.field_228142_f_) {
                NarratorChatListener.field_193643_a.func_216864_a(this.func_228155_c_());
            }
        }

        public void func_228146_a_() {
            Suggestion suggestion = this.field_241576_d_.get(this.field_228142_f_);
            CommandSuggestionHelper.this.field_228110_s_ = true;
            CommandSuggestionHelper.this.field_228095_d_.func_146180_a(suggestion.apply(this.field_228140_d_));
            int \u26032 = suggestion.getRange().getStart() + suggestion.getText().length();
            CommandSuggestionHelper.this.field_228095_d_.func_212422_f(\u26032);
            CommandSuggestionHelper.this.field_228095_d_.func_146199_i(\u26032);
            this.func_228153_b_(this.field_228142_f_);
            CommandSuggestionHelper.this.field_228110_s_ = false;
            this.field_228144_h_ = true;
        }

        private String func_228155_c_() {
            this.field_228145_i_ = this.field_228142_f_;
            Suggestion suggestion = this.field_241576_d_.get(this.field_228142_f_);
            Message \u26032 = suggestion.getTooltip();
            if (\u26032 != null) {
                return I18n.func_135052_a("narration.suggestion.tooltip", this.field_228142_f_ + 1, this.field_241576_d_.size(), suggestion.getText(), \u26032.getString());
            }
            return I18n.func_135052_a("narration.suggestion", this.field_228142_f_ + 1, this.field_241576_d_.size(), suggestion.getText());
        }

        public void func_228152_b_() {
            CommandSuggestionHelper.this.field_228108_q_ = null;
        }
    }
}

